###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_test_moment_MLE.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_test_moment_MLE.R".
##


####################################################
### code chunk number : Simulations: 1 theta, not good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
n = 1e4

set.seed(1) 
theta = 1 / rgamma(n = 1, shape = v0 / 2, rate = v0 * sigma0^2 / 2); theta
mu = rnorm(n = 1, mean = mu0, sd = sqrt(theta / k0)); mu
x = rnorm(n, mean = mu, sd = sqrt(theta)) ## the sample

data_outline(x)

x1 = seq(0, 10, by = 0.01)
y1 = dnorm(x = x1, mean = mu, sd = sqrt(theta))

## Histogram
dev.new()
col = c("blue")
lty = 1
xlim = c(0, 10)
ylim = c(0, 0.3)
hist(x, probability = TRUE, breaks = 100, xlim = xlim, ylim = ylim, 
    main = paste("Histogram of" , "x"), 
    xlab = "x", sub = "(a)")
lines(x1, y1, col = "blue", lwd = 4)
leg.txt = expression(paste(N, group("(",list(4.817, 1.866),")"), sep = ""))
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/N-NIG_Histogram_x_1", type = c("pdf"))
savePlot(filename = "figure/N-NIG_Histogram_x_1", type = c("jpg"))

## Moment estimators
source("subfunctions.R")
mu0_1_v0_1_u0_1 = Moment_estimators(x); round(mu0_1_v0_1_u0_1, 3)

## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu0_1_v0_1_u0_1, x = x); res_Newtons
mu0_2_v0_2_u0_2 = res_Newtons$root; round(mu0_2_v0_2_u0_2, 3)


####################################################
### code chunk number : Simulations: n theta, good: k0 = 1, sigma0 = 1, u0 = 2
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0    ## hyperparameter
k0 = 1          ## hyperparameter
v0 = 6; v0      ## hyperparameter
sigma0 = 1      ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
n = 1e4

set.seed(1) 
theta = 1 / rgamma(n = n, shape = v0 / 2, rate = v0 * sigma0^2 / 2); range(theta)
mu = rnorm(n = n, mean = mu0, sd = sqrt(theta / k0)); range(mu)
x = rnorm(n, mean = mu, sd = sqrt(theta)) ## the sample

data_outline(x)

x2 = seq(-10, 15, by = 0.01)
y2 = Marginal_density_mu0_v0_u0(x = x2, mu0, v0, u0)

## Histogram
dev.new()
col = c("blue")
lty = 1
xlim = c(-10, 15)
ylim = c(0, 0.3)
hist(x, probability = TRUE, breaks = 100, xlim = xlim, ylim = ylim, 
    main = paste("Histogram of" , "x"), 
    xlab = "x", sub = "(b)")
# lines(density(x), col = "blue", lwd = 4)
lines(x2, y2, col = "blue", lwd = 4)
leg.txt = expression(paste(t[6], group("(",list(3, 2),")"), sep = ""))
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/N-NIG_Histogram_x_2", type = c("pdf"))
savePlot(filename = "figure/N-NIG_Histogram_x_2", type = c("jpg"))

## Moment estimators
source("subfunctions.R")
mu0_1_v0_1_u0_1 = Moment_estimators(x); round(mu0_1_v0_1_u0_1, 3)


## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu0_1_v0_1_u0_1, x = x); res_Newtons
mu0_2_v0_2_u0_2 = res_Newtons$root; round(mu0_2_v0_2_u0_2, 3)


####################################################
### code chunk number : Simulations: n theta, good: k0 = 2, sigma0 = sqrt(4/3), u0 = 2
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu0 = 3; mu0        ## hyperparameter
k0 = 2              ## hyperparameter
v0 = 6; v0          ## hyperparameter
sigma0 = sqrt(4/3)  ## hyperparameter
u0 = sigma0^2 * (k0 + 1) / k0; u0
n = 1e4

set.seed(1) 
theta = 1 / rgamma(n = n, shape = v0 / 2, rate = v0 * sigma0^2 / 2); range(theta)
mu = rnorm(n = n, mean = mu0, sd = sqrt(theta / k0)); range(mu)
x = rnorm(n, mean = mu, sd = sqrt(theta)) ## the sample

data_outline(x)

x3 = seq(-10, 15, by = 0.01)
y3 = Marginal_density_mu0_v0_u0(x = x3, mu0, v0, u0)

## Histogram
dev.new()
col = c("blue")
lty = 1
xlim = c(-10, 15)
ylim = c(0, 0.3)
hist(x, probability = TRUE, breaks = 100, xlim = xlim, ylim = ylim, 
    main = paste("Histogram of" , "x"), 
    xlab = "x", sub = "(c)")
# lines(density(x), col = "blue", lwd = 4)
lines(x3, y3, col = "blue", lwd = 4)
leg.txt = expression(paste(t[6], group("(",list(3, 2),")"), sep = ""))
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/N-NIG_Histogram_x_3", type = c("pdf"))
savePlot(filename = "figure/N-NIG_Histogram_x_3", type = c("jpg"))

## Moment estimators
source("subfunctions.R")
mu0_1_v0_1_u0_1 = Moment_estimators(x); round(mu0_1_v0_1_u0_1, 3)


## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu0_1_v0_1_u0_1, x = x); res_Newtons
mu0_2_v0_2_u0_2 = res_Newtons$root; round(mu0_2_v0_2_u0_2, 3)


